/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize;

import io.gitlab.jfronny.commons.SamWithReceiver;
import io.gitlab.jfronny.commons.serialize.emulated.WriterItemView;
import java.io.Flushable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public abstract class SerializeWriter<TEx extends Exception, T extends SerializeWriter<TEx, T>>
implements AutoCloseable,
Flushable {
    private static final Pattern VALID_JSON_NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][-+]?[0-9]+)?");
    protected boolean lenient = false;
    protected boolean serializeNulls = true;
    protected boolean serializeSpecialFloatingPointValues = false;

    public boolean isLenient() {
        return this.lenient;
    }

    public T setLenient(boolean lenient) {
        this.lenient = lenient;
        if (lenient) {
            return ((SerializeWriter)this.setSerializeSpecialFloatingPointValues(true)).setSerializeNulls(true);
        }
        return (T)this;
    }

    public boolean isSerializeNulls() {
        return this.serializeNulls;
    }

    public T setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
        return (T)this;
    }

    public boolean isSerializeSpecialFloatingPointValues() {
        return this.serializeSpecialFloatingPointValues;
    }

    public T setSerializeSpecialFloatingPointValues(boolean serializeSpecialFloatingPointValues) {
        this.serializeSpecialFloatingPointValues = serializeSpecialFloatingPointValues;
        return (T)this;
    }

    public boolean isStandaloneNames() {
        return false;
    }

    public abstract T beginArray() throws TEx;

    public abstract T endArray() throws TEx;

    public T array(SerializeWriterConsumer<TEx, T> consumer) throws TEx {
        return ((SerializeWriter)consumer.accept(this.beginArray())).endObject();
    }

    public abstract T beginObject() throws TEx;

    public abstract T endObject() throws TEx;

    public T object(SerializeWriterConsumer<TEx, T> consumer) throws TEx {
        return ((SerializeWriter)consumer.accept(this.beginObject())).endObject();
    }

    public abstract T comment(String var1) throws TEx;

    public abstract T name(String var1) throws TEx;

    public T nullValue() throws TEx {
        if (this.serializeNulls) {
            return this.literalValue("null");
        }
        throw new IllegalArgumentException("Null values are not allowed");
    }

    public abstract T value(String var1) throws TEx;

    public T value(boolean value) throws TEx {
        return this.literalValue(value ? "true" : "false");
    }

    public T value(Boolean value) throws TEx {
        return value == null ? this.nullValue() : this.value((boolean)value);
    }

    public T value(float value) throws TEx {
        if (!this.serializeSpecialFloatingPointValues && (Float.isNaN(value) || Float.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        return this.literalValue(Float.toString(value));
    }

    public T value(Float value) throws TEx {
        return value == null ? this.nullValue() : this.value(value.floatValue());
    }

    public T value(double value) throws TEx {
        if (!this.serializeSpecialFloatingPointValues && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value);
        }
        return this.literalValue(Double.toString(value));
    }

    public T value(Double value) throws TEx {
        return value == null ? this.nullValue() : this.value((double)value);
    }

    public T value(long value) throws TEx {
        return this.literalValue(Long.toString(value));
    }

    public T value(Long value) throws TEx {
        return value == null ? this.nullValue() : this.value((long)value);
    }

    public T value(Number value) throws TEx {
        if (value == null) {
            return this.nullValue();
        }
        String s = value.toString();
        Class<?> numberClass = value.getClass();
        if (!SerializeWriter.alwaysCreatesValidJsonNumber(numberClass)) {
            if (s.equals("-Infinity") || s.equals("Infinity") || s.equals("NaN")) {
                if (!this.serializeSpecialFloatingPointValues) {
                    throw new IllegalArgumentException("Numeric values must be finite, but was " + s);
                }
            } else if (numberClass != Float.class && numberClass != Double.class && !VALID_JSON_NUMBER_PATTERN.matcher(s).matches()) {
                throw new IllegalArgumentException("String created by " + String.valueOf(numberClass) + " is not a valid number: " + s);
            }
        }
        return this.literalValue(s);
    }

    private static boolean alwaysCreatesValidJsonNumber(Class<? extends Number> c) {
        return c == Integer.class || c == Long.class || c == Byte.class || c == Short.class || c == BigDecimal.class || c == BigInteger.class || c == AtomicInteger.class || c == AtomicLong.class;
    }

    public abstract T literalValue(String var1) throws TEx;

    public SerializeWriter<TEx, ?> createView() {
        return new WriterItemView(this);
    }

    protected abstract TEx createException(String var1);

    @Override
    public abstract void close() throws TEx;

    @SamWithReceiver
    public static interface SerializeWriterConsumer<TEx extends Exception, T extends SerializeWriter<TEx, T>> {
        public T accept(T var1) throws TEx;
    }

    public static abstract class Delegating<TEx extends Exception, Writer extends Delegating<TEx, Writer>>
    extends SerializeWriter<TEx, Writer> {
        protected final SerializeWriter<TEx, ?> delegate;

        public Delegating(SerializeWriter<TEx, ?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isLenient() {
            this.lenient = this.delegate.isLenient();
            return this.lenient;
        }

        @Override
        public Writer setLenient(boolean lenient) {
            this.lenient = lenient;
            this.delegate.setLenient(lenient);
            return (Writer)this;
        }

        @Override
        public boolean isSerializeNulls() {
            this.serializeNulls = this.delegate.isSerializeNulls();
            return this.serializeNulls;
        }

        @Override
        public Writer setSerializeNulls(boolean serializeNulls) {
            this.serializeNulls = serializeNulls;
            this.delegate.setSerializeNulls(serializeNulls);
            return (Writer)this;
        }

        @Override
        public boolean isSerializeSpecialFloatingPointValues() {
            this.serializeSpecialFloatingPointValues = this.delegate.isSerializeSpecialFloatingPointValues();
            return this.serializeSpecialFloatingPointValues;
        }

        @Override
        public Writer setSerializeSpecialFloatingPointValues(boolean serializeSpecialFloatingPointValues) {
            this.serializeSpecialFloatingPointValues = serializeSpecialFloatingPointValues;
            this.delegate.setSerializeSpecialFloatingPointValues(serializeSpecialFloatingPointValues);
            return (Writer)this;
        }

        @Override
        public boolean isStandaloneNames() {
            return this.delegate.isStandaloneNames();
        }

        @Override
        protected TEx createException(String message) {
            return this.delegate.createException(message);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public abstract Writer nullValue() throws TEx;

        @Override
        public abstract Writer value(boolean var1) throws TEx;

        @Override
        public abstract Writer value(float var1) throws TEx;

        @Override
        public abstract Writer value(double var1) throws TEx;

        @Override
        public abstract Writer value(long var1) throws TEx;

        @Override
        public abstract Writer value(Number var1) throws TEx;
    }
}

